<?php
// header.php

// Define the base URL if needed
$base_url = "http://thevaletvan.co.uk/stack/"; 
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link rel="stylesheet" href="styles.css"> <!-- Link to your main CSS file -->
    <style>
 /* Header styling */
/* Header styling */
.header {
    background: rgba(0, 0, 0, 0.6);
    padding: 15px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.7);
    color: #d4af37; /* Creamy gold text */
    display: flex;
    justify-content: space-between;
    align-items: center;
    position: fixed;
    top: 0;
    width: 100%;
    z-index: 1000;
    box-sizing: border-box; /* Ensure padding is included in the width */
}

.header .logo {
    font-size: 24px;
    font-weight: bold;
    white-space: nowrap; /* Prevent logo text from wrapping */

}

.header .nav {
    display: flex;
    gap: 20px;
    flex-wrap: wrap; /* Allow nav items to wrap on smaller screens */
}

.header .nav a {
    color: #d4af37; /* Creamy gold text */
    text-decoration: none;
    font-size: 18px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.header .nav a img {
    width: 20px;
    height: 20px;
}

.header .nav a:hover {
    color: #b2ac8a; /* Lighter creamy gold on hover */
}

/* Add some space at the top of the body to avoid content being hidden under the header */
body {
    margin-top: 60px; /* Adjust as needed */
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .header {
        flex-direction: column; /* Stack logo and nav vertically */
        align-items: flex-start; /* Align items to the start */
        padding: 10px; /* Reduce padding on smaller screens */
    }

    .header .logo {
        font-size: 20px; /* Reduce font size of logo */
        margin-bottom: 10px; /* Space between logo and nav */
    }

    .header .nav {
        gap: 15px; /* Reduce gap between nav items */
    }

    .header .nav a {
        font-size: 16px; /* Reduce font size of nav links */
        gap: 6px; /* Adjust gap between text and icon */
    }

    .header .nav a img {
        width: 16px; /* Adjust icon size */
        height: 16px;
    }
}

@media (max-width: 480px) {
    .header {
        padding: 8px; /* Further reduce padding on very small screens */
    }

    .header .logo {
        font-size: 18px; /* Further reduce font size of logo */
    }

    .header .nav {
        gap: 10px; /* Further reduce gap between nav items */
    }

    .header .nav a {
        font-size: 14px; /* Further reduce font size of nav links */
        gap: 4px; /* Adjust gap between text and icon */
    }

    .header .nav a img {
        width: 14px; /* Further adjust icon size */
        height: 14px;
    }
}

    </style>
</head>
<body>
    <header class="header">
        <div class="logo"><img src="images/Logo.png" height="50px" padding="0px"></div>
        <nav class="nav">
            <a href="<?php echo $base_url; ?>dashboardadmin.php"><img src="icons/dashboard.png" alt="Dashboard"> Dashboard</a>
            <a href="<?php echo $base_url; ?>users.php"><img src="icons/users.png" alt="Users"> Users</a>
            <a href="<?php echo $base_url; ?>adminsettings.php"><img src="icons/settings.png" alt="Settings"> Settings</a>
            <a href="<?php echo $base_url; ?>logout.php"><img src="icons/logout.png" alt="Logout"> Logout</a>
        </nav>
    </header>
</body>
</html>
